/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class EffectRenderingInventoryScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation EFFECT_BACKGROUND_LARGE_SPRITE = ResourceLocation.withDefaultNamespace("container/inventory/effect_background_large");
    private static final ResourceLocation EFFECT_BACKGROUND_SMALL_SPRITE = ResourceLocation.withDefaultNamespace("container/inventory/effect_background_small");

    public EffectRenderingInventoryScreen(T p_98701_, Inventory p_98702_, Component p_98703_) {
        super(p_98701_, p_98702_, p_98703_);
    }

    @Override
    public void render(GuiGraphics p_283027_, int p_281444_, int p_282953_, float p_281666_) {
        super.render(p_283027_, p_281444_, p_282953_, p_281666_);
        this.renderEffects(p_283027_, p_281444_, p_282953_);
    }

    public boolean canSeeEffects() {
        int $$0 = this.leftPos + this.imageWidth + 2;
        int $$1 = this.width - $$0;
        return $$1 >= 32;
    }

    private void renderEffects(GuiGraphics p_281945_, int p_282601_, int p_282335_) {
        int $$3 = this.leftPos + this.imageWidth + 2;
        int $$4 = this.width - $$3;
        Collection<MobEffectInstance> $$5 = this.minecraft.player.getActiveEffects();
        if ($$5.isEmpty() || $$4 < 32) {
            return;
        }
        boolean $$6 = $$4 >= 120;
        int $$7 = 33;
        if ($$5.size() > 5) {
            $$7 = 132 / ($$5.size() - 1);
        }
        List $$8 = Ordering.natural().sortedCopy($$5);
        this.renderBackgrounds(p_281945_, $$3, $$7, $$8, $$6);
        this.renderIcons(p_281945_, $$3, $$7, $$8, $$6);
        if ($$6) {
            this.renderLabels(p_281945_, $$3, $$7, $$8);
        } else if (p_282601_ >= $$3 && p_282601_ <= $$3 + 33) {
            int $$9 = this.topPos;
            MobEffectInstance $$10 = null;
            for (MobEffectInstance $$11 : $$8) {
                if (p_282335_ >= $$9 && p_282335_ <= $$9 + $$7) {
                    $$10 = $$11;
                }
                $$9 += $$7;
            }
            if ($$10 != null) {
                List<Component> $$12 = List.of(this.getEffectName($$10), MobEffectUtil.formatDuration($$10, 1.0f, this.minecraft.level.tickRateManager().tickrate()));
                p_281945_.renderTooltip(this.font, $$12, Optional.empty(), p_282601_, p_282335_);
            }
        }
    }

    private void renderBackgrounds(GuiGraphics p_281540_, int p_282479_, int p_283680_, Iterable<MobEffectInstance> p_282013_, boolean p_283630_) {
        int $$5 = this.topPos;
        for (MobEffectInstance $$6 : p_282013_) {
            if (p_283630_) {
                p_281540_.blitSprite(EFFECT_BACKGROUND_LARGE_SPRITE, p_282479_, $$5, 120, 32);
            } else {
                p_281540_.blitSprite(EFFECT_BACKGROUND_SMALL_SPRITE, p_282479_, $$5, 32, 32);
            }
            $$5 += p_283680_;
        }
    }

    private void renderIcons(GuiGraphics p_282745_, int p_282521_, int p_282291_, Iterable<MobEffectInstance> p_282642_, boolean p_281536_) {
        MobEffectTextureManager $$5 = this.minecraft.getMobEffectTextures();
        int $$6 = this.topPos;
        for (MobEffectInstance $$7 : p_282642_) {
            Holder<MobEffect> $$8 = $$7.getEffect();
            TextureAtlasSprite $$9 = $$5.get($$8);
            p_282745_.blit(p_282521_ + (p_281536_ ? 6 : 7), $$6 + 7, 0, 18, 18, $$9);
            $$6 += p_282291_;
        }
    }

    private void renderLabels(GuiGraphics p_281462_, int p_283484_, int p_282057_, Iterable<MobEffectInstance> p_281986_) {
        int $$4 = this.topPos;
        for (MobEffectInstance $$5 : p_281986_) {
            Component $$6 = this.getEffectName($$5);
            p_281462_.drawString(this.font, $$6, p_283484_ + 10 + 18, $$4 + 6, 0xFFFFFF);
            Component $$7 = MobEffectUtil.formatDuration($$5, 1.0f, this.minecraft.level.tickRateManager().tickrate());
            p_281462_.drawString(this.font, $$7, p_283484_ + 10 + 18, $$4 + 6 + 10, 0x7F7F7F);
            $$4 += p_282057_;
        }
    }

    private Component getEffectName(MobEffectInstance p_194001_) {
        MutableComponent $$1 = p_194001_.getEffect().value().getDisplayName().copy();
        if (p_194001_.getAmplifier() >= 1 && p_194001_.getAmplifier() <= 9) {
            $$1.append(CommonComponents.SPACE).append(Component.translatable("enchantment.level." + (p_194001_.getAmplifier() + 1)));
        }
        return $$1;
    }
}

